/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */
'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/patients/PatientView' ],
    function (Portal, Backbone, Marionette, $, _, jqm) {

        return Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _) {
            ListGenerator.RecentPatientListView = Backbone.Marionette.CollectionView.extend({
                tagName: 'ul',
                id: 'patient-list',
                attributes: {
                    'data-role': 'listview',
                    'data-inset': 'true',
                    'data-divider-theme': 'd',
                    'data-icon': false,
                    'data-split-icon': 'star'
                },
                itemView: ListGenerator.PatientView,
                collectionEvents: {
                    'sync': 'refreshAutocomplete'
                },
                events: {
                    'tap a': 'selectItem',
                    'keyup a': 'keyupList'
                },
                onShow: function () {
//									this.$el.listview();
	                var that = this;

//	                this.$el.parent().on('create', function() {
//		                that.$el.children().remove();
//		                that.$el.listview();
//	                });
	                that.$el.children().remove();
                    this.$el.parent().trigger('create');
                },
                onClose: function () {
                    this.stopListening();
                    this.off();
                },
                refreshAutocomplete: function () {
									this.$el.listview();
									this.$el.listview('refresh');
									this.delegateEvents();
                },
                selectItem: function (e) {
                    e.preventDefault();
                    this.showConfirmation($(e.target).closest('li'));
                },
                showConfirmation: function (item) {
                    var patient = this.collection.at(item.index());

                    ListGenerator.model.get('patient').set(patient.attributes);
                    ListGenerator.vent.trigger("open:popup:confirmation", {positionTo: item});
                },
                keyupList: function (e) {
                    if (e.which === 13 || e.which === 32 || e.which === 39) {
                        // Enter || Space Bar || Right Arrow
                        this.selectItem(e);
                    }
                }
            });
        });
    });